/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.CEC;
import com.quantumdata.busmon.parser.CECBit;
import com.quantumdata.busmon.parser.CECByte;
import com.quantumdata.std.CECConstants;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CECMessage {
    protected int bitSize;
    protected Hashtable<String, String> faultyReasons = new Hashtable();
    protected Vector<CECBit> bits;
    protected Vector<CECByte> data;
    protected int srcAddress;
    protected int dstAddress;
    protected int opcode;
    protected boolean missingACK;
    public static boolean recordingStarts = true;

    public CECMessage(Vector<CECBit> vector) {
        int n;
        int n2;
        this.bits = new Vector<CECBit>(vector);
        this.data = new Vector();
        this.bitSize = vector.size();
        if (vector == null) {
            return;
        }
        if (vector.size() == 0) {
            return;
        }
        if (recordingStarts) {
            if (vector.size() % 10 != 1) {
                this.faultyReasons.put("INCL", "The message ends in an incomplete byte.\n");
            }
        } else if (vector.size() % 10 != 0) {
            this.faultyReasons.put("INCL", "The message ends in an incomplete byte.\n");
        }
        if (recordingStarts) {
            if (vector.get(0).isStart()) {
                n2 = 1;
            } else {
                this.faultyReasons.put("STRT", "No START bit was seen after an idle period.  Messages must begin with a START bit to be valid.\n");
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        while (n2 < vector.size()) {
            this.data.add(new CECByte(vector, n2));
            n2 += 10;
        }
        for (n = 0; n < this.data.size() - 1; ++n) {
            if (!this.data.get(n).isError()) continue;
            this.faultyReasons.put("TIME", "The message contains one or more bits that do not conform to CEC timing specifications.\n");
        }
        for (n = 0; n < vector.size(); ++n) {
            if (!vector.get(n).isErrorSignal()) continue;
            this.faultyReasons.put("ERRS", "At least one error signal was observed on the CEC bus.\n");
            break;
        }
        if (this.data.size() < 1) {
            this.faultyReasons.put("NULL", "The message is empty (contains no data nor source/destination addresses).\n");
        } else {
            for (n = 0; n < this.data.size() - 1; ++n) {
                if (!this.data.get(n).getEOM()) continue;
                this.faultyReasons.put("EOMS", "The message contains EOM bits in the middle of transmission; EOM should only occur at the end.\n");
                return;
            }
            this.srcAddress = this.data.get(0).getData() >> 4 & 0xF;
            this.dstAddress = this.data.get(0).getData() & 0xF;
            this.missingACK = false;
            for (n = 0; n < this.data.size(); ++n) {
                if (this.dstAddress == 15) {
                    if (this.data.get(n).getACK()) continue;
                    this.missingACK = true;
                    continue;
                }
                if (!this.data.get(n).getACK()) continue;
                this.missingACK = true;
            }
            if (this.missingACK) {
                this.faultyReasons.put("ACKS", "The message is missing one or more acknowledgements from the target(s).\n");
            }
            if (this.data.size() != 1) {
                int n3;
                int n4;
                this.opcode = this.data.get(1).getData();
                block0 : switch (this.opcode) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 11: 
                    case 13: 
                    case 15: 
                    case 54: 
                    case 69: 
                    case 70: 
                    case 113: 
                    case 125: 
                    case 131: 
                    case 133: 
                    case 139: 
                    case 140: 
                    case 143: 
                    case 145: 
                    case 159: 
                    case 255: {
                        n4 = 2;
                        n3 = 2;
                        break;
                    }
                    case 8: 
                    case 10: 
                    case 26: 
                    case 27: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 114: 
                    case 122: 
                    case 126: 
                    case 141: 
                    case 142: 
                    case 144: 
                    case 154: 
                    case 158: {
                        n4 = 3;
                        n3 = 3;
                        break;
                    }
                    case 9: {
                        switch (this.data.get(2).getData()) {
                            case 2: {
                                n4 = 10;
                                n3 = 10;
                                break block0;
                            }
                            case 3: {
                                n4 = 7;
                                n3 = 7;
                                break block0;
                            }
                            case 4: {
                                n4 = 4;
                                n3 = 4;
                                break block0;
                            }
                            case 5: {
                                n4 = 5;
                                n3 = 5;
                                break block0;
                            }
                        }
                        n4 = 3;
                        n3 = 3;
                        break;
                    }
                    case 0: 
                    case 7: 
                    case 129: 
                    case 130: 
                    case 134: 
                    case 157: {
                        n4 = 4;
                        n3 = 4;
                        break;
                    }
                    case 50: 
                    case 132: 
                    case 135: {
                        n4 = 5;
                        n3 = 5;
                        break;
                    }
                    case 128: 
                    case 146: {
                        n4 = 6;
                        n3 = 6;
                        break;
                    }
                    case 147: {
                        n4 = 9;
                        n3 = 9;
                        break;
                    }
                    case 137: 
                    case 138: {
                        n4 = 2;
                        n3 = 16;
                        break;
                    }
                    case 68: 
                    case 71: 
                    case 100: 
                    case 103: {
                        n4 = 3;
                        n3 = 16;
                        break;
                    }
                    case 112: {
                        n4 = 2;
                        n3 = 4;
                        break;
                    }
                    case 53: {
                        n4 = 3;
                        n3 = 5;
                        break;
                    }
                    case 51: 
                    case 52: {
                        n4 = 13;
                        n3 = 13;
                        break;
                    }
                    case 161: 
                    case 162: {
                        n4 = 11;
                        n3 = 12;
                        break;
                    }
                    case 151: 
                    case 153: {
                        n4 = 16;
                        n3 = 16;
                        break;
                    }
                    case 160: {
                        n4 = 6;
                        n3 = 16;
                        break;
                    }
                    default: {
                        n4 = 1;
                        n3 = 16;
                    }
                }
                if (this.data.size() < n4) {
                    this.faultyReasons.put("SHRT", "The message was shorter than the opcode it contains will allow.\n");
                } else if (this.data.size() > n3) {
                    this.faultyReasons.put("LONG", "The message was longer than the opcode it contains will allow.\n");
                }
            }
        }
    }

    public String getDirection() {
        if (this.data != null && this.data.size() > 0) {
            return CECConstants.getCECAddressName(this.srcAddress) + " -> " + CECConstants.getCECAddressName(this.dstAddress);
        }
        return "";
    }

    public String getExplanation() {
        if (this.data != null && this.data.size() > 1) {
            return CECConstants.getCECOpcodeName(this.opcode);
        }
        if (this.data.size() == 1) {
            if (this.isBad()) {
                return "CEC Ping or UnACKed Header";
            }
            return "CEC Ping";
        }
        return "Null Message";
    }

    public String getDetails() {
        StringBuffer stringBuffer;
        block46: {
            stringBuffer = new StringBuffer();
            try {
                stringBuffer.append(String.format("Size of message:      %d bytes (%d bits total)\n", this.data.size(), this.bitSize));
                stringBuffer.append(String.format("Message source:       %s (0x%01X)\n", CECConstants.getCECAddressName(this.srcAddress), this.srcAddress));
                stringBuffer.append(String.format("Message destination:  %s (0x%01X)\n", CECConstants.getCECAddressName(this.dstAddress), this.dstAddress));
                if (this.data.size() > 1) {
                    stringBuffer.append(String.format("Message opcode:       %s (0x%02X)\n", CECConstants.getCECOpcodeName(this.opcode), this.opcode));
                    switch (this.opcode) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 11: 
                        case 13: 
                        case 15: 
                        case 54: 
                        case 69: 
                        case 70: 
                        case 131: 
                        case 133: 
                        case 139: 
                        case 140: 
                        case 143: 
                        case 145: 
                        case 255: {
                            stringBuffer.append("                     (No details for this opcode.)\n");
                            break;
                        }
                        case 129: 
                        case 130: 
                        case 134: 
                        case 157: {
                            stringBuffer.append("  Physical Address:   " + CEC.getPhysicalAddress(this.data, 2) + "\n");
                            break;
                        }
                        case 112: {
                            if (this.data.size() > 2) {
                                stringBuffer.append("  Physical Address:   " + CEC.getPhysicalAddress(this.data, 2) + "\n");
                                break;
                            }
                            stringBuffer.append("  Type:               Termination request\n");
                            break;
                        }
                        case 128: {
                            stringBuffer.append("  Original Address:   " + CEC.getPhysicalAddress(this.data, 2) + "\n  New Address:        " + CEC.getPhysicalAddress(this.data, 4) + "\n");
                            break;
                        }
                        case 9: {
                            stringBuffer.append("  Record Source:      " + CEC.getRecordSource(this.data, 2) + "\n");
                            break;
                        }
                        case 10: {
                            stringBuffer.append("  Record Status:      " + CECConstants.getRecStatusInfo(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 132: {
                            stringBuffer.append("  Physical Address:   " + CEC.getPhysicalAddress(this.data, 2) + "\n  Device Type:        " + CECConstants.getDeviceType(this.data.get(4).getData()) + "\n");
                            break;
                        }
                        case 50: {
                            stringBuffer.append("  Language:           " + CEC.getLanguage(this.data, 2) + "\n");
                            break;
                        }
                        case 66: {
                            stringBuffer.append("  Deck Control Mode:  " + CECConstants.getDeckControlMode(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 27: {
                            stringBuffer.append("  Deck Status:        " + CECConstants.getDeckInfo(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 8: 
                        case 26: {
                            stringBuffer.append("  Status Request:     " + CECConstants.getStatusRequest(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 65: {
                            stringBuffer.append("  Play Mode:          " + CECConstants.getPlayMode(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 146: {
                            stringBuffer.append("  Analogue Service ID:" + CEC.getAnalogueServiceIdentification(this.data, 2) + "\n");
                            break;
                        }
                        case 147: {
                            stringBuffer.append("  Digital Service ID: " + CEC.getDigitalServiceIdentification(this.data, 2) + "\n");
                            break;
                        }
                        case 7: {
                            stringBuffer.append("  Tuner Device Info:  " + CEC.getTunerDeviceInfo(this.data, 2) + "\n");
                            break;
                        }
                        case 135: {
                            stringBuffer.append("  Device Vendor ID:   " + CEC.getVendorID(this.data, 2) + "\n");
                            break;
                        }
                        case 137: {
                            stringBuffer.append("  Vendor Spec Data:   TBI\n");
                            break;
                        }
                        case 138: {
                            stringBuffer.append("  Vendor Spec RC:     TBI\n");
                            break;
                        }
                        case 100: {
                            stringBuffer.append("  Display Control:    " + CECConstants.getDisplayControl(this.data.get(2).getData()) + "\n  OSD String:         " + CEC.getRemainderAsString(this.data, 3, 13) + "\n");
                            break;
                        }
                        case 71: {
                            stringBuffer.append("  OSD Name:           " + CEC.getRemainderAsString(this.data, 2, 14) + "\n");
                            break;
                        }
                        case 141: {
                            stringBuffer.append("  Menu Request Type:  " + CECConstants.getMenuRequestType(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 142: {
                            stringBuffer.append("  Menu State:         " + CECConstants.getMenuState(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 68: {
                            stringBuffer.append("  UI Command:         " + CECConstants.getUserControlCode(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 144: {
                            stringBuffer.append("  Power Status:       " + CECConstants.getPowerStatus(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 0: {
                            stringBuffer.append("  Feature Opcode:     " + CECConstants.getCECOpcodeName(this.data.get(2).getData()) + "\n  Abort Reason:       " + CECConstants.getAbortReason(this.data.get(3).getData()) + "\n");
                            break;
                        }
                        case 158: {
                            stringBuffer.append("  CEC Version:        " + CECConstants.getCECVersion(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 103: {
                            stringBuffer.append("  Program Title:      " + CEC.getRemainderAsString(this.data, 2, 14) + "\n");
                            break;
                        }
                        case 51: 
                        case 52: {
                            stringBuffer.append("  Start Time/Date:    \n" + CEC.getDate(this.data, 2) + "\n  Duration:           " + CEC.getTime(this.data, 6, true) + "\n  Recording Sequence: " + CECConstants.getRecordingSequence(this.data.get(8).getData()) + "\n  Analogue Service ID:" + CEC.getAnalogueServiceIdentification(this.data, 9) + "\n");
                            break;
                        }
                        case 151: 
                        case 153: {
                            stringBuffer.append("  Start Time/Date:    \n" + CEC.getDate(this.data, 2) + "\n  Duration:           " + CEC.getTime(this.data, 6, true) + "\n  Recording Sequence: " + CECConstants.getRecordingSequence(this.data.get(8).getData()) + "\n  Digital Service ID: " + CEC.getDigitalServiceIdentification(this.data, 9) + "\n");
                            break;
                        }
                        case 161: 
                        case 162: {
                            stringBuffer.append("  Start Time/Date:    \n" + CEC.getDate(this.data, 2) + "\n  Duration:           " + CEC.getTime(this.data, 6, true) + "\n  Recording Sequence: " + CECConstants.getRecordingSequence(this.data.get(8).getData()) + "\n  Ext. Src. Specifier:" + CECConstants.getExternalSourceSpecifier(this.data.get(9).getData()) + "\n");
                            if (this.data.get(9).getData() == 4) {
                                stringBuffer.append("    External Plug:    " + this.data.get(10).getData() + "\n");
                                break;
                            }
                            if (this.data.get(9).getData() == 5) {
                                stringBuffer.append("    External P.A.:    " + CEC.getPhysicalAddress(this.data, 10) + "\n");
                                break;
                            }
                            break block46;
                        }
                        case 67: {
                            stringBuffer.append("  Timer Clr. Status:  " + CECConstants.getTimerClearedStatusData(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 160: {
                            stringBuffer.append("  Device Vendor ID:   " + CEC.getVendorID(this.data, 2) + "\n");
                            break;
                        }
                        case 122: {
                            stringBuffer.append("  Audio Status:       " + CECConstants.getAudioStatus(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 114: 
                        case 126: {
                            stringBuffer.append("  Sys. Audio Status:  " + CECConstants.getSystemAudioStatus(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 154: {
                            stringBuffer.append("  Audio Rate:         " + CECConstants.getAudioRate(this.data.get(2).getData()) + "\n");
                            break;
                        }
                        case 53: {
                            stringBuffer.append("  Timer Status Data:  " + CECConstants.getTimerStatusData(this.data.get(2).getData()) + "\n");
                            if (this.data.size() > 4) {
                                stringBuffer.append("  Duration:           " + CEC.getTime(this.data, 3, true) + "\n");
                            } else {
                                break;
                            }
                        }
                    }
                    break block46;
                }
                stringBuffer.append("Message opcode:       None (ping message)\n");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                stringBuffer.append("\nError: The message unexpectedly ended in the middle of parsing opcode parameters.\n");
            }
        }
        stringBuffer.append("\n\n");
        stringBuffer.append("Bit Timings\n");
        stringBuffer.append("-------+--------+--------+-----+-----+-----\n");
        stringBuffer.append("Number | Lo(ms) | Hi(ms) | Inv | Dat | Val \n");
        stringBuffer.append("-------+--------+--------+-----+-----+-----\n");
        for (int i = 0; i < this.bits.size(); ++i) {
            stringBuffer.append(String.format("%5d  | %s\n", i, this.bits.get(i).getPeriodString()));
        }
        stringBuffer.append("-------+--------+--------+-----+-----+-----\n");
        return stringBuffer.toString();
    }

    public int getOpcode() {
        return this.opcode;
    }

    public boolean isBad() {
        return this.whyBad().size() != 0;
    }

    public Hashtable<String, String> whyBad() {
        return this.faultyReasons;
    }

    public Vector<CECByte> getData() {
        return this.data;
    }
}

